using System;
using Borland.Eco.Cache;
using Borland.Eco.DataRepresentation;
using Borland.Eco.UmlRt;

namespace ChangeLogging
{
	public delegate void ChangeDelegate(string message);

	public class ChangeTrackingCache: ChainedCacheBase
	{
		public event ChangeDelegate MemberChanged;

		public override void SetCurrentValue(Locator locator,  IStructuralFeature structuralFeature, object value)
		{
			IClass c = NextCache.GetUmlClass(locator);
			object oldValue = NextCache.GetCurrentValue(locator, structuralFeature);

			string message = "Member " + c.Name + "." + structuralFeature.Name +
				" changes value from " + oldValue.ToString() + " to " + value.ToString();

			MemberChanged(message);

			NextCache.SetCurrentValue(locator, structuralFeature, value);
		}
	}
}
